Base64 utility for Windows 
==========================

Base64 encode or decode FILE, or standard input, and print to standard output.

	> base64 --help
	Usage: base64 [OPTION]...  [FILE]
	Base64 encode or decode FILE, or standard input, and print to standard output

	With no FILE, or when FILE is -, read standard input.
	Mandatory arguments to long options are mandatory for short options too.
	  -d, --decode          decode data
	  -i, --ignore-garbage  when decoding, ignore non-alphabet characters
	  -w, --wrap=COLS       wrap encoded lines after COLS character (default 76).
	                          Use 0 to disable line wrapping
	  -s, --string="TEXT"   use "TEXT" as input string
	  -o, --output=OUTFILE  output to OUTFILE (default=stdout)
	  -h, --help            display this help and exit
	  -v, --version         output version information and exit
	  -L, --license         display the license and exit
	The data are encoded as described for the base64 alphabet in RFC 4648.
	When decoding, the input may contain newlines in addition to the bytes of
	the formal alphabet.  Use --ignore-garbage to attempt to recover
	from any other non-alphabet bytes in the encoded stream.


Extra features for Windows: the "--string" and "--output" options
-----------------------------------------------------------------

Use the `--string` (`-s`) option to pass a text string instead of a file as input. 
This avoids many of the problems using pipes and redirections on Windows platforms. 

	> base64 --string "abcdxyz"
	YWJjZHh5eg==

	> base64 -d -s "MAQwAgUA" | hexdump
	000000  30 04 30 02 05 00

Use the `--output` (`-o`) option to create an output file directly. 

	> base64 -d -o outfile.jpg jpginb64.txt

as an alternative to 

	> base64 -d jpginb64.txt > outfile.jpg

License and copyright
---------------------
```
> base64 --version
base64 (for Windows) 1.3.1 (32-bit) [Oct  5 2025 19:21:25]

Written by David Ireland <https://di-mgt.com.au/contact/>
Copyright (C) 2021-25 DI Management Services Pty Ltd.
License: BSD-2-Clause. Type ``base64 -L`` for license info.
```

Licensed under the [BSD-2-Clause License](https://opensource.org/license/BSD-2-Clause)
	
More details
------------
See our web site <https://di-mgt.com.au/base64-for-windows.html>.


David Ireland  
DI Management Services Pty Ltd  
Australia  
<https://di-mgt.com.au/contact/>  
First published 2021-06-26. Last Updated 2025-10-05.  	
