DIGESTVALUE.EXE FOR WINDOWS
---------------------------

Computes the digest value of a file and displays in base64 encoding.

	> digestvalue -h
	Usage: digestvalue [[-1]|-2|-3|-4|-5|-m] [-x] [-h|L|v] [FILE]...
	Compute the digest value for each FILE.
	With no file, read standard input.
	-1    use SHA-1 digest algorithm (default)
	-2    use SHA-256 digest algorithm
	-3    use SHA-384 digest algorithm
	-4    use SHA-224 digest algorithm
	-5    use SHA-512 digest algorithm
	-m    use MD5 digest algorithm
	-x    display digest in hex encoding (default=base64)
	-h    display this help and exit
	-L    display the license and exit
	-v    display version information and exit

The default is to display the SHA-1 digest in base64.

	> digestvalue abc.txt
	qZk+NkcGgWq6PiVxeFDCbJzQ2J0=
	
Specify files using a wildcard.

	> digestvalue *.txt
	98O8HYCOBHMq32eZZczDTKeuNEE=  123-9.txt
	qZk+NkcGgWq6PiVxeFDCbJzQ2J0=  abc.txt
	Kq5sNclPz7QV2+lfQIuc6R7oRu0=  hello.txt
	iKW4Z8PRECB3huZlI80eSkhNppc=  hellon.txt
	
Compute the SHA-256 digest and display in hexadecimal.

	> digestvalue -2x abc.txt
	ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad
	
	
Iterate through digest algorithms (SHA-1, SHA-224, SHA-256, ..., SHA-512)

	> for %a in (1,4,2,3,5) do @digestvalue -x -%a abc.txt
	a9993e364706816aba3e25717850c26c9cd0d89d
	23097d223405d8228642a477bda255b32aadbce4bda0b3f7e36c9da7
	ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad
	cb00753f45a35e8bb5a03d699ac65007272c32ab0eded1631a8b605a43ff5bed8086072ba1e7cc2358baeca134c825a7
	ddaf35a193617abacc417349ae20413112e6fa4e89a97ea20a9eeee64b55d39a2192992a274fc1a836ba3c23a3feebbd454d4423643ce80e2a9ac94fa54ca49f
	
Check these against <https://di-mgt.com.au/sha_testvectors.html>.

License and copyright
---------------------
```
digestvalue -v
digestvalue 1.2.0 (32-bit) [Oct 27 2025 12:35:31]

Written by David Ireland <https://di-mgt.com.au/contact/>.
Copyright (C) 2017-25 DI Management Services Pty Ltd.
License: BSD-2-Clause. Type ``digestvalue -L`` for license info
```

Licensed under the [BSD-2-Clause License](https://opensource.org/license/BSD-2-Clause)
	
More details
------------
See our web site <https://di-mgt.com.au/generate-file-digest-value.html>.


David Ireland  
DI Management Services Pty Ltd  
Australia  
<https://di-mgt.com.au/contact/>  
First published 2017-03-09. Version 1.2.0 compiled 2025-10-27.  
